<?php
/**
 * Plugin Name: Contador de Visitas Sencillo
 * Description: Un plugin básico para contar y mostrar el número de visitas de entradas y páginas.
 * Version: 1.1.0
 * Author: Francisco Javier González García
 * Author URI: https://wwww.supresor.com
 */

// Función para contar las visitas
function contador_visitas_sencillo_contar_visita() {
    if (is_single() || is_page()) {
        global $post;
        $post_id = $post->ID;
        $contador = get_post_meta($post_id, 'contador_visitas_sencillo', true);
        if ($contador == '') {
            $contador = 0;
        }
        $contador++;
        update_post_meta($post_id, 'contador_visitas_sencillo', $contador);
    }
}
add_action('wp_head', 'contador_visitas_sencillo_contar_visita');

// Función para mostrar el contador en el pie de página (opcional)
function contador_visitas_sencillo_mostrar_contador() {
    global $post;
    $post_id = $post->ID;
    $contador = get_post_meta($post_id, 'contador_visitas_sencillo', true);
    if ($contador == '') {
        $contador = 0;
    }
    echo '<p>V.S ' . $contador . ' H.</p>';
}
//add_action('wp_footer', 'contador_visitas_sencillo_mostrar_contador');

// Funciones para añadir y mostrar la columna en el escritorio
function contador_visitas_sencillo_agregar_columna($columns) {
    $columns['contador_visitas_sencillo'] = 'Visitas';
    return $columns;
}
add_filter('manage_edit-post_columns', 'contador_visitas_sencillo_agregar_columna');
add_filter('manage_edit-page_columns', 'contador_visitas_sencillo_agregar_columna');

function contador_visitas_sencillo_mostrar_conteo_en_columna($column, $post_id) {
    if ($column == 'contador_visitas_sencillo') {
        $contador = get_post_meta($post_id, 'contador_visitas_sencillo', true);
        if ($contador == '') {
            $contador = 0;
        }
        echo $contador;
    }
}
add_action('manage_posts_custom_column', 'contador_visitas_sencillo_mostrar_conteo_en_columna', 10, 2);
add_action('manage_pages_custom_column', 'contador_visitas_sencillo_mostrar_conteo_en_columna', 10, 2);
?>